/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.components;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class FurnitureInventoryComponent
implements EntityComponent {
    private List<Entity> inventoryItems = new ArrayList<Entity>();

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        FurnitureInventoryComponent cloned = new FurnitureInventoryComponent();
        for (Entity decorationItem : this.inventoryItems) {
            try {
                cloned.add(decorationItem.clone(messageDispatcher, tiledMap), messageDispatcher);
            }
            catch (NotEnoughInventorySpaceException e) {
                System.err.println("Failed to add cloned item to " + this.getClass().getSimpleName());
            }
        }
        return cloned;
    }

    public void clear() {
        this.inventoryItems.clear();
    }

    public void add(Entity entityToAdd, MessageDispatcher messageDispatcher) throws NotEnoughInventorySpaceException {
        if (entityToAdd.getType().equals((Object)EntityType.ITEM)) {
            ItemEntityAttributes attributesToAdd = (ItemEntityAttributes)entityToAdd.getPhysicalEntityComponent().getAttributes();
            Entity matchingItem = this.getMatchingItem(attributesToAdd);
            if (matchingItem != null) {
                ItemEntityAttributes matchingItemAttributes = (ItemEntityAttributes)matchingItem.getPhysicalEntityComponent().getAttributes();
                if (matchingItemAttributes.getQuantity() + attributesToAdd.getQuantity() > attributesToAdd.getItemType().getMaxStackSize()) {
                    throw new NotEnoughInventorySpaceException();
                }
                matchingItemAttributes.setQuantity(matchingItemAttributes.getQuantity() + attributesToAdd.getQuantity());
                matchingItemAttributes.setNumAllocated(matchingItemAttributes.getQuantity());
                messageDispatcher.dispatchMessage(322, entityToAdd);
                messageDispatcher.dispatchMessage(324, matchingItem);
            } else {
                attributesToAdd.setItemPlacement(ItemPlacement.ON_GROUND);
                attributesToAdd.setNumAllocated(attributesToAdd.getQuantity());
                entityToAdd.getLocationComponent().setWorldPosition(null, false);
                entityToAdd.getLocationComponent().setOrientation(EntityAssetOrientation.DOWN);
                this.inventoryItems.add(entityToAdd);
                messageDispatcher.dispatchMessage(324, entityToAdd);
            }
        } else {
            this.inventoryItems.add(entityToAdd);
        }
    }

    private Entity getMatchingItem(ItemEntityAttributes attributes) {
        for (Entity inventoryItem : this.inventoryItems) {
            ItemEntityAttributes inventoryItemAttributes;
            if (!inventoryItem.getType().equals((Object)EntityType.ITEM) || !(inventoryItemAttributes = (ItemEntityAttributes)inventoryItem.getPhysicalEntityComponent().getAttributes()).canMerge(attributes)) continue;
            return inventoryItem;
        }
        return null;
    }

    public List<Entity> getInventoryItems() {
        return this.inventoryItems;
    }

    public boolean isEmpty() {
        return this.inventoryItems.isEmpty();
    }

    public void setItems(List<Entity> items) {
        this.inventoryItems = items;
    }

    public void remove(Entity targetInventoryItem) {
        this.inventoryItems.remove(targetInventoryItem);
    }

    public static class NotEnoughInventorySpaceException
    extends Exception {
    }
}

